#include <bits/stdc++.h>
#define ll long long
#define ld long double
#define sp ' '
#define en '\n'
#define smin(a, b) a = min(a, b)
#define smax(a, b) a = max(a, b)
using namespace std;
const int N = 2e5 + 2;
const int inf = 2e9;
vector<int> g[N], childs[N];
int was[N], sz[N], par[N];
void Dfs(int s, int e) {
    sz[s] = 1;
    for (auto u : g[s]) {
        if (u != e && !was[u]) {
            Dfs(u, s);
            sz[s] += sz[u];
        }
    }
}
int Find(int s, int e, int n) {
    for (auto u : g[s]) {
        if (u != e && !was[u]) {
            if (2 * sz[u] > n) return Find(u, s, n);
        }
    }
    return s;
}
int FindCentroid(int s) {
    Dfs(s, 0);
    return Find(s, 0, sz[s]);
}
void Decompose(int s) {
    s = FindCentroid(s);
    was[s] = 1;
    for (auto u : g[s]) {
        if (!was[u]) {
            childs[s].push_back(u);
            par[u] = s;
            Decompose(u);
        }
    }
}
ll sum[N], uk;
void Add(int s, int x) {
    uk += x;
    while (s > 0) {
        sum[s] += x;
        s = par[s];
    }
}
int Evlos(int s) {
    for (int u : childs[s]) {
        if (2 * sum[u] > uk) return Evlos(u);
    }
    return s;
}
int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int n; cin >> n;
    for (int i = 0; i < n - 1; i++) {
        int u, v; cin >> u >> v;
        g[u].push_back(v);
        g[v].push_back(u);
    }
    Decompose(1);
    int root = 1;
    for (int i = 1; i <= n; i++) if (par[i] == 0) root = i;
    for (int i = 1; i <= n; i++) {
        int x; cin >> x;
        Add(i, x);
    }
    int q; cin >> q;
    cout << Evlos(root) << en;
    while (q--) {
        int i, x;
        cin >> x >> i;
        Add(i, x);
        cout << Evlos(root) << en;
    }
    return 0;
}